/*
 * Distributed Systems
 * Winter Term 2006/07
 * Lab 3
 * Paul Staroch, 0425426
 */

package at.ac.tuwien.dslab.rmi.client.command;

import at.ac.tuwien.dslab.rmi.client.command.Command;
import at.ac.tuwien.dslab.rmi.common.interfaces.IFileManager;
import at.ac.tuwien.dslab.rmi.common.interfaces.IUser;
import at.ac.tuwien.dslab.rmi.common.impl.FileManException;
import at.ac.tuwien.dslab.rmi.common.impl.UserImpl;

import java.rmi.RemoteException;

/**
 * CreateRepositoryCommand represents the command "create-repo"
 */
public class CreateRepositoryCommand extends Command {
	/**
	 * Constructor - sets minimal and maximal argument number
	 */
	public CreateRepositoryCommand() {
		super();
		minArgumentNumber=4;
		maxArgumentNumber=-1;
	}

	/**
	 * performs the command
	 *
	 * @param args arguments to the command
	 * @return message for the user (about success or failure)
	 * @throws FileManException if an error occurs
	 */
	public String executeNoCheckNumber(String... args)
			throws FileManException {
                IFileManager fileMan;
		try {
			fileMan=getFileManager(args[2]);
		}
		catch(FileManException fme) {
			return fme.getMessage();
		}

		IUser owner=new UserImpl(args[0],args[1]);
		
		String[] allowedUsers=new String[args.length-4];
		System.arraycopy(args, 4, allowedUsers, 0, allowedUsers.length);

		/* create repository */
		try {
			fileMan.createRepository(args[3], owner, allowedUsers);
		}
		catch(RemoteException re) {
			return "Communication error.";
		}
		
		return "Repository successfully created.";
	}
}

