/*
 * Distributed Systems
 * Winter Term 2006/07
 * Lab 3
 * Paul Staroch, 0425426
 */

package at.ac.tuwien.dslab.rmi.client.command;

import at.ac.tuwien.dslab.rmi.client.command.Command;
import at.ac.tuwien.dslab.rmi.common.impl.FileManException;
import at.ac.tuwien.dslab.rmi.common.impl.InvalidCommandException;
import at.ac.tuwien.dslab.rmi.common.interfaces.IFileManager;
import at.ac.tuwien.dslab.rmi.common.impl.UserImpl;
import at.ac.tuwien.dslab.rmi.client.FileManClientConfig;
import at.ac.tuwien.dslab.rmi.client.FileManConfigException;

import java.io.File;
import java.io.IOException;

import java.rmi.RemoteException;

/**
 * DeleteDocumentCommand represents the command "del"
 */
public class DeleteDocumentCommand extends Command {
	/**
	 * Constructor - sets minimal and maximal argument number
	 */
	public DeleteDocumentCommand() {
		super();
		minArgumentNumber=1;
		maxArgumentNumber=1;
	}

	/**
	 * performs the command
	 *
	 * @param args arguments to the command
	 * @return message for the user (about success or failure)
	 * @throws InvalidCommandException if the command fails due to wrong
	 *      arguments
	 * @throws FileManException if an error occurs
	 */
	public String executeNoCheckNumber(String... args)
			throws FileManException {
		/* read configuration */
		FileManClientConfig config;
		try {
			config=new FileManClientConfig(".");
		}
		catch(FileManConfigException fmce) {
			throw new InvalidCommandException("Can't read "+
					"repository configuration file.");
		}

		if(!config.configFileExists()) {
			throw new InvalidCommandException
				("No repository config file found.");
		}

		IFileManager fileMan;
		try {
			fileMan=getFileManager(config.getHost());
		}
		catch (FileManException fme) {
			return fme.getMessage();
		}

		UserImpl user=new UserImpl();
		user.setName(config.getUsername());
		user.setPasswordHashed(config.getPassword());

		if(args[0].indexOf(File.separator)>-1) {
			throw new InvalidCommandException(
					"The file you want to delete is not "+
					"located in the local working "+
					"directory.");
		}

		File file=new File(args[0]);
		if(!file.exists()) {
			throw new InvalidCommandException("The file you want "+
					"to delete does not exist.");
		}
		else if(!file.isFile()) {
			throw new InvalidCommandException("The file you want "+
					"to delete is not a normal file.");
		}

		/* remove document from repository */
		try {
			fileMan.removeDocument
				(config.getRepository(),user,args[0]);
		}
		catch (RemoteException re) {
			return "Communication error";
		}

		/* delete local file */
		file.delete();
	
		/* update configuration file */
		try {
			config.deleteFile(args[0]);
			config.writeConfig();
		}
		catch(IOException ioe) {
			return "Error while updating repository config file.";
		}
				
		return "File successfully deleted.";
	}
}

