/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dslab.rmi.common.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import sun.misc.BASE64Encoder;

public class DSLabUtils {
    private DSLabUtils() {
    }

    public static String hashTextWithSHA(String string) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        try {
            messageDigest.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] byArray = messageDigest.digest();
        String string2 = new BASE64Encoder().encode(byArray);
        return string2;
    }

    public static boolean isValidEmailAddress(String string) {
        return string != null && string.matches(".+@.+\\.[a-z]+");
    }

    public static Properties loadPropertiesFromClasspath(String string) throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        properties.load(inputStream);
        return properties;
    }

    public static Properties loadPropertiesFromFile(String string) throws IOException {
        Properties properties = new Properties();
        if (string == null || !new File(string).isFile()) {
            return null;
        }
        properties.load(new FileInputStream(string));
        return properties;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] byArray = new byte[(int)l];
        int n2 = 0;
        for (n = 0; n < byArray.length && (n2 = ((InputStream)fileInputStream).read(byArray, n, byArray.length - n)) >= 0; n += n2) {
        }
        if (n < byArray.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)fileInputStream).close();
        return byArray;
    }

    public static boolean deleteDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = DSLabUtils.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static boolean deleteDir(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = DSLabUtils.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static boolean deleteDirContent(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = DSLabUtils.deleteDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeInFile(byte[] byArray, File file) throws IOException {
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            filterOutputStream.write(byArray);
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }
}

