% SME: Abgabe 2, Aufgabe 3 (UE5)
% 
% Gegeben seien zwei Klassen w1, w2 mit normalverteilten Merkmalen X1~N(4,1) 
% und X2~(6,1). Berechnen sie jeweils fr P(w1)=P(w2)=0.5 sowie fr P(w1)=0.9,
% P(w2)=0.1
%             - die Fehlerrate(error rate) fr die Entscheidungsgrenze x*=4
%             - die Bayes error rate (und Entscheidungsgrenze)
%             - Plotten Sie auerdem den conditional error

% Hinweis: ermitteln Sie die Entscheidungsgrenzen bzw.
% Entscheidungsregionen wiederum grafisch. Sie bentigen die
% Matlab-Funktion normcdf.

clear;
close all;

mu1 = 4;
mu2 = 6;
std = 1;
P_w1 = 0.5;
P_w2 = 0.5;
X = [0:0.01:10];
P1 = normcdf(X,mu1,std);
P2 = normcdf(X,mu2,std);
x_stern = 4;
x_bayes = 5;
values = [mu1, std, P_w1; mu2, std, P_w2];

% Posteriors
% P(w2|x) = P(x|w2)*P(w2)/p(x)
Post_w1=[];
Post_w2=[];
for i = 1:length(X)
    Post_w1(i) = posterior(X(i), 1, values);
    Post_w2(i) = posterior(X(i), 2, values);
end

logind = (X <= x_stern);
Klasse1 = X(logind);
logind = (X > x_stern);
Klasse2 = X(logind);

% conditional error
error_w1 = [];
error_w2 = [];
for i = 1:length(Klasse2)
    error_w2(i) = posterior(Klasse2(i), 1, values);
end
for i = 1:length(Klasse1)
    error_w1(i) = posterior(Klasse1(i), 2, values);
end
error = [error_w1 error_w2];

% error rate
err1 = P_w2*normcdf(x_stern, mu2, std);
err2 = P_w1*(1-normcdf(x_stern, mu1, std));
err = err1 + err2

% Bayes error rate und Entscheidungsgrenze
% liegt grafisch bei 5, x_bayes
% P(error|x) = min[P(w1|x),P(w2|x)] = 1-max[P(w1|x), P(w2|x)]
% bayes_err = gemittelt
bayes_err = [];
for i = 1:length(X)
    bayes_cond_err(i) = 1-max(posterior(X(i), 1, values), posterior(X(i), 2, values));
end
bayes_err1 = P_w2*normcdf(x_bayes, mu2, std);
bayes_err2 = P_w1*(1-normcdf(x_bayes, mu1, std));
bayes_err = bayes_err1 + bayes_err2

% Wert von x_stern als Gerade einzeichnen:
g = ones(2,1);
b = ones(2,1);
l = ones(2,1);
g(1) = x_stern;
g(2) = x_stern;
l(1) = 0.0;
l(2) = 1.0;
b(1) = x_bayes;
b(2) = x_bayes;

fnx1 = normpdf(X,mu1,std)*P_w1;
fnx2 = normpdf(X,mu2,std)*P_w2;

figure(1)
plot(X,Post_w1, 'g-');
hold on
plot(X, Post_w2, 'b-');
plot(X, fnx1,'r--');
plot(X, fnx2, 'b--');
plot(b, l, '-.m');
legend('P(w1|x)','P(w2|x)','p(x|w1)*P(w1)', 'p(x|w2)*P(w2)', 'x_b',2)
hold off

figure(2)
plot(X, error, 'k-', 'LineWidth', 2);
hold on
plot(X, fnx1,'r--');
plot(X, fnx2, 'b--');
plot(X, bayes_cond_err, 'g-', 'LineWidth', 2);
plot(g, l, '-.m');
plot(b, l, '-.m');
text(x_stern, 0.5, 'x^*\rightarrow', 'HorizontalAlignment', 'right', 'FontSize', 14)
text(x_bayes, 0.5, '\leftarrow x_b', 'HorizontalAlignment', 'left', 'FontSize', 14)
legend('cond. error','p(x|w1)*P(w1)','p(x|w2)*P(w2)','cond. error bayes rule',1)
hold off

%-------------------------------------------------------------------
P_w1 = 0.9;
P_w2 = 0.1;
x_bayes = 6.1;
values = [mu1, std, P_w1; mu2, std, P_w2];

% Posteriors
% P(w2|x) = P(x|w2)*P(w2)/p(x)
Post_w1=[];
Post_w2=[];
for i = 1:length(X)
    Post_w1(i) = posterior(X(i), 1, values);
    Post_w2(i) = posterior(X(i), 2, values);
end

%--------------------------------------------------------------------
% Fehlerrate (error rate) fr Entscheidungsgrenze x* = 4
%--------------------------------------------------------------------
% P(error) = -inf +inf  Integral(P(error|x)p(x)dx 
%          = Sr1 P(w2)*p(x,Klasse2) + Sr2 P(w1)*p(x,Klasse1)
% conditional error P(error|x)
% P(error|x) = P(w2|x) falls fuer w1 entschieden
%              P(w1|x) falls fuer w2 entschieden
%--------------------------------------------------------------------

logind = (X <= x_stern);
Klasse1 = X(logind);
logind = (X > x_stern);
Klasse2 = X(logind);

% conditional error
error_w1 = [];
error_w2 = [];
for i = 1:length(Klasse2)
    error_w2(i) = posterior(Klasse2(i), 1, values);
end
for i = 1:length(Klasse1)
    error_w1(i) = posterior(Klasse1(i), 2, values);
end
error = [error_w1 error_w2];

% error rate
err1 = P_w2*normcdf(x_stern, mu2, std);
err2 = P_w1*(1-normcdf(x_stern, mu1, std));
err = err1 + err2

%--------------------------------------------------------------------
% Bayes error rate und Entscheidungsgrenze
%--------------------------------------------------------------------
% liegt grafisch bei 6.1, x_bayes
% P(error|x) = min[P(w1|x),P(w2|x)] = 1-max[P(w1|x), P(w2|x)]
% bayes_err = gemittelt
bayes_err = [];
for i = 1:length(X)
    bayes_cond_err(i) = 1-max(posterior(X(i), 1, values), posterior(X(i), 2, values));
end
bayes_err1 = P_w2*normcdf(x_bayes, mu2, std);
bayes_err2 = P_w1*(1-normcdf(x_bayes, mu1, std));
bayes_err = bayes_err1 + bayes_err2

%--------------------------------------------------------------------
% Wert von x_stern und x_bayes als Gerade einzeichnen:
b(1) = x_bayes;
b(2) = x_bayes;

fnx1 = normpdf(X,mu1,std)*P_w1;
fnx2 = normpdf(X,mu2,std)*P_w2;

figure(3)
plot(X, Post_w1, 'g-.');
hold on
plot(X, Post_w2, 'b-.');
plot(X, fnx1,'r--');
plot(X, fnx2, 'b--');
plot(b, l, '-.m');
legend('P(w1|x)','P(w2|x)','p(x|w1)*P(w1)', 'p(x|w2)*P(w2)', 'x_b',2)
hold off

figure(4)
plot(X, error, 'k-', 'LineWidth', 2);
hold on
plot(X, fnx1,'r--');
plot(X, fnx2, 'b--');
plot(X, bayes_cond_err, 'g-', 'LineWidth', 2);
plot(g, l, '-.m');
plot(b, l, '-.m');
text(x_stern, 0.5, 'x^*\rightarrow', 'HorizontalAlignment', 'right', 'FontSize', 14)
text(x_bayes, 0.5, '\leftarrow x_b', 'HorizontalAlignment', 'left', 'FontSize', 14)
legend('cond. error','p(x|w1)*P(w1)','p(x|w2)*P(w2)','cond. error bayes rule',1)
hold off
