
clear;

% Aufgabe 1.2
% Trainieren des Perceptrons mit vorgegenenen Trainingsvektoren
%
% benoetigt perco.m von Aufgabe 1.1


% --------------------------------------------------------------------------------------------
% Trainigsdaten 1
% --------------------------------------------------------------------------------------------

% lade Trainigsdaten:
X = load('perceptrondata');
% Anzahl der Trainigsvektoren:
anz = size(X,1);

% Targetvektoren werden geladen:
temp = load('perceptrontarget1');
t1 = zeros(anz,1);   % Initialisierung Targetvektor


% Targetwerte muessen vom Bereich [0,1] auf den Bereich [-1,1] gebracht werden:
for i = 1:anz
    if ( temp(i) == 0 )
        t1(i) = -1;
    else
        t1(i) = 1;
    end
end


% Klasseneinteilung plotten

% speichere Vektoren in zwei verschiedenen Klassen:
logind = (t1 == 1);
class1 = X(logind,:);  % alle Vektoren, die zur Klasse 1 gehoeren
logind = (t1 == -1);
class2 = X(logind,:);  % alle Vektoren, die zur Klasse 2 gehoeren

% Plotte die Klasseneinteilung:
figure(1)
clf
axis equal
hold on
plot(class1(:,1), class1(:,2), '.b');
hold on
plot(class2(:,1), class2(:,2), '.r');
hold on


% Perceptron trainieren

% X in homogenen Koordinaten darstellen (die homogene Komponente 
% ist der erste Eintrag im Vektor):
hComp = ones(1,anz);
T = [hComp; X'];

% maximale Trainigsschritte:
max = 1000;

% Perceptron trainieren (w wird ausgegeben)
w = perco(T, t1, max)

% Perceptron plotten
x = 0:.05:0.7;
y = (-w(2)*x-w(1))/w(3);
plot(x,y,'-g')
hold off


% Margin berechnen

margin = 100;   % Initialisierung

% Gewichtsvektor:
w1 = w(2);
w2 = w(3);

% Margin berechnen:
for i = 1:anz
    gm = dot([w1 w2], [X(i,1) X(i,2)]) / sqrt(w1^2 + w2^2);
    if ( abs(gm) < margin )
        margin = abs(gm);
    end
end

% Margin ausgeben:
margin


% Obergrenze berechnen

% Initialisierung:
max = 0;
min = 100;

% Grenze ausrechnen:
for i = 1:anz
    maxi = sqrt(X(i,1)^2 + X(i,2)^2) * sqrt(w1^2 + w2^2);
    mini = dot([w1 w2], [X(i,1) X(i,2)]);
    if ( maxi > max )
        max = maxi;
    end
    if ( abs(mini) < min )
        min = abs(mini);
    end
end

% Obergrenze ausgeben:
limit = ( max / min )^2




% --------------------------------------------------------------------------------------------
% Trainigsdaten 2
% --------------------------------------------------------------------------------------------

% lade Trainigsdaten:
X = load('perceptrondata');
% Anzahl der Trainigsvektoren:
anz = size(X,1);

% Targetvektoren werden geladen:
temp = load('perceptrontarget2');
t1 = zeros(anz,1);   % Initialisierung Targetvektor

% Targetwerte muessen vom Bereich [0,1] auf den Bereich [-1,1] gebracht werden:
for i = 1:anz
    if ( temp(i) == 0 )
        t1(i) = -1;
    else
        t1(i) = 1;
    end
end


% Klasseneinteilung plotten

% speichere Vektoren in zwei verschiedenen Klassen
logind = (t1 == 1);
class1 = X(logind,:);   % alle Vektoren, die zur Klasse 1 gehoeren
logind = (t1 == -1);
class2 = X(logind,:);   % alle Vektoren, die zur Klasse 2 gehoeren

% Plotte die Klasseneinteilung
figure(2)
clf
axis equal
hold on
plot(class1(:,1), class1(:,2), '.b');
hold on
plot(class2(:,1), class2(:,2), '.r');
hold on


% Perceptron trainieren

% X in homogenen Koordinaten darstellen (die homogene Komponente 
% ist der erste Eintrag im Vektor):
hComp = ones(1,anz);
T = [hComp; X'];

% maximale Trainigsschritte:
max = 1000;

% Perceptron trainieren
w = perco(T, t1, max)

% Perceptron plotten
x = 0.2:.05:0.9;
y = (-w(2)*x-w(1))/w(3);
plot(x,y,'-g')
hold off

% Margin und Obergrenze wurden nicht ausgerechnet, da es sich um ein nicht linear separierbares Problem
% handelt - es gibt daher keine richtige Loesung w


