% ub 1.1 statistical pattern recognition
% implement online learning algorithm for perceptron
% 27-10-06

n = 100;    % number of samples to generate
L = 1;      % type of data:  1..OR 
            %                2..AND 
            %                3..XOR

% get data from user and check if valid
n = input('Anzahl der samples, die generiert werden sollen: ')
L = input('type of data (1..OR, 2..AND, 3..XOR): ')
if (~((L == 1 ) | (L == 2 ) |(L == 3 )))
    disp('ungltige Eingabe von L!')
    disp('L wird auf 1 (OR) gesetzt')
    L = 1; % set to default 
end

if ( n <= 1 )
    disp('n ist zu klein. Wird auf 2 gesetzt')
    n = 2;
end

% generate data and target vector
[X, t] = genData(n,L);

% prepare for plotting
logind = (t == 1);
patterns1 = X(:,logind);
logind = (t == -1);
patterns2 = X(:,logind);

% train perceptron on generated data
maxEpoches = 40;
% convert X into homogenous coordinates
one_vec = ones(1,n);
Z = [one_vec; X];
% train perceptron
w = perco(Z, t, maxEpoches);

% plot data and decision boundary
figure(1)
clf
hold on
% plot data
plot(patterns1(1,:),patterns1(2,:), '.b');
plot(patterns2(1,:),patterns2(2,:), '.r');
% calculate decision boundary
x = -0.2:.05:1.2;
y = (-w(2)*x-w(1))/w(3);    % decision boundary
% normalize weight vector
zr = [0,0];
nv = [w(2),w(3)];
nv = nv/norm(nv);
rz = [zr ; nv];
de=plot(x,y, '-c');            % plot decision region
we=plot(rz(:,1),rz(:,2), 'm-'); % plot weight vector w
tm = [we,de];
legend(tm,'weight vector w', 'decision boundary', -1);
axis equal
hold off

% Margin berechnen
margin = 100;   % Initialisierung

% Gewichtsvektor:
w1 = w(2);
w2 = w(3);

% Margin berechnen:
for i = 1:n
    gm = dot([w1 w2], [X(1,i) X(2,i)]) / sqrt(w1^2 + w2^2);
    if ( abs(gm) < margin )
        margin = abs(gm);
    end
end

margin
