
clear;

% Aufgabe 3
% Evaluierung des Ergebnisses aus Bonusaufgabe T-1 fuer zwei konkrete
% normalverteilte Zufallsvariablen

% ----------------------------------------------------------------------
% Daten der Normalverteilungen
% Wenn zwei andere Normalverteilungen verwendet werden sollen, einfach 
% hier die Daten ndern (m entspricht den Mittelwerten, s den Sigmas).
%
m1 = -7;
s1 = sqrt(30);
m2 = 4;
s2 = sqrt(13);
%
% ----------------------------------------------------------------------

% Berechnung der Grenze mit der Formel aus der Aufgabe T-1 (Wert wird
% auch ausgegeben):

x_stern = ( (m1 * s2) + (m2 * s1) ) / ( s1 + s2 )


% ---------------------------------------------------------------------
% Plotten der Verteilungsfunktionen
% ---------------------------------------------------------------------

% Werte ermitteln fuer die erste normalverteilte Zufallsvariable:
% F1(X)

x = ones(245);
y = ones(245);
d = -30;

for i = 1:245
    t = (d - m1) / s1;
    y(i) = normcdf(t);
    x(i) = d;
    d = d + 0.2;
end

figure
axis equal
plot(x, y, '-b');
hold on


% Werte ermitteln fuer die zweite normalverteilte Zufallsvariable:
% 1 - F2(X)

x = ones(245);
y = ones(245);
d = -30;

for i = 1:245
    t = (d - m2) / s2;
    y(i) = 1 - normcdf(t);
    x(i) = d;
    d = d + 0.2;
end

plot(x, y, '-g');
hold on


% Wert von x_stern als Gerade einzeichnen:

g = ones(2);
l = ones(2);
g(1) = x_stern;
g(2) = x_stern;
l(1) = 0.0;
l(2) = 1.0;

plot(g, l, '-r');
hold off



% ---------------------------------------------------------------------
% Plotten der Dichtefunktionen
% ---------------------------------------------------------------------

x = ones(245);
y = ones(245);
d = -30;

for i = 1:245
    t = (d - m1) / s1;
    y(i) = normpdf(t);
    x(i) = d;
    d = d + 0.2;
end

figure
axis equal
plot(x, y, '-g');
hold on

x = ones(245);
y = ones(245);
d = -30;

for i = 1:245
    t = (d - m2) / s2;
    y(i) = normpdf(t);
    x(i) = d;
    d = d + 0.2;
end

plot(x, y, '-b');
hold on

g = ones(2);
l = ones(2);
g(1) = x_stern;
g(2) = x_stern;
l(1) = 0.0;
l(2) = 0.5;

plot(g, l, '-r');
hold off