function [data, target] = genData(n, L)
%function generates OR (L=1), AND (L=2), XOR (L=3) data
%vector

%generates integer values 0 or 1
data = randint(2,n,2);
switch L
    case 1
        %OR Data
        tmp = data(1,:) | data(2,:);
    case 2
        %AND Data
        tmp = data(1,:) & data(2,:);
    case 3
        %XOR Data
        tmp = xor(data(1,:),data(2,:));
    otherwise
        error('L must be 1, 2 or 3')
end

for i = 1:n
    if (tmp(i) == 0)
        target(i) = -1;
    else
        target(i) = 1;
    end
end

%add noise between [-0.2, 0.2]
a = -0.2; 
b = 0.2;
eps = a + (b-a) * rand(2,n);
data = data + eps; % noisy data
