
% Aufgabe UE-11
% Entscheidungsgrenze und Fehlerrate berechnen

clear;

anz = 200;

% Datenstze laden
D = load('perceptrondata');
t1 = load('perceptrontarget1');
t2 = load('perceptrontarget2');

% homogene Koordinaten:
h = ones(200,1);
X = [h D];

% Pseudo-Inverse berechnen:
PI = inv(X'*X) * X';


% -----------------------------------------------------------
% Erster Datensatz (perceptrontarget1)
% -----------------------------------------------------------

% Klasseneinteilung von [0,1] auf [-1,1] bringen

T1 = ones(200,1);

for i = 1:anz
    if ( t1(i) == 0 )
        T1(i) = -1;
    else
        T1(i) = 1;
    end
end

% Entscheidungsgrenze berechnen
w1 = PI * T1


% Ergebnis plotten

% speichere Vektoren in zwei verschiedenen Klassen
logind = (T1 == 1);
class1 = D(logind,:);   % alle Vektoren, die zur Klasse 1 gehoeren
logind = (T1 == -1);
class2 = D(logind,:);   % alle Vektoren, die zur Klasse 2 gehoeren

% Plotte die Klasseneinteilung
figure(1)
clf
axis equal
hold on
plot(class1(:,1), class1(:,2), '.b');
hold on
plot(class2(:,1), class2(:,2), '.r');
hold on

% Plotte Entscheidungsgrenze
x = 0.1:.05:0.7;
y = ( (-w1(2)*x - w1(1))/w1(3) );
plot(x,y,'-g')
hold off


% Fehlerrate berechnen

bias = -w1(1);

richtig = 0;
count = 0;
for i = 1:anz
    richtig = 0;
    c = D(i,:) * w1(2:3) - bias;
    
    if ( (c > 0) && (T1(i) == 1) )
        richtig = 1;
    end
    if ( (c < 0) && (T1(i) == -1) )
        richtig = 1;
    end
    
    if ( richtig == 0)
        count = count + 1;
    end
end

fehlerrate1 = count / anz



% -----------------------------------------------------------
% Zweiter Datensatz (perceptrontarget2)
% -----------------------------------------------------------

% Klasseneinteilung von [0,1] auf [-1,1] bringen

T2 = ones(200,1);

for i = 1:anz
    if ( t2(i) == 0 )
        T2(i) = -1;
    else
        T2(i) = 1;
    end
end

% Entscheidungsgrenze berechnen
w2 = PI * T2

% Ergebnis plotten

% speichere Vektoren in zwei verschiedenen Klassen
logind = (T2 == 1);
class1 = D(logind,:);   % alle Vektoren, die zur Klasse 1 gehoeren
logind = (T2 == -1);
class2 = D(logind,:);   % alle Vektoren, die zur Klasse 2 gehoeren

% Plotte die Klasseneinteilung
figure(2)
clf
axis equal
hold on
plot(class1(:,1), class1(:,2), '.b');
hold on
plot(class2(:,1), class2(:,2), '.r');
hold on

% Plotte Entscheidungsgrenze
x = 0.1:.05:0.7;
y = ( (-w2(2)*x - w2(1))/w2(3) );
plot(x,y,'-g')
hold off


% Fehlerrate berechnen

bias = -w2(1);

richtig = 0;
count = 0;
for i = 1:anz
    richtig = 0;
    c = D(i,:) * w2(2:3) - bias;
    
    if ( (c > 0) && (T2(i) == 1) )
        richtig = 1;
    end
    if ( (c < 0) && (T2(i) == -1) )
        richtig = 1;
    end
    
    if ( richtig == 0)
        count = count + 1;
    end
end

fehlerrate2 = count / anz



