% Statistische Mustererkennung LU
%
% Uebung 12, Abgabe 4
%
% Aufgabenstellung:
% 
% Gegeben seien zwei Zufallsvariablen X1, X2 mit Var(X1)=2 und Var(X2) = 7.
% Berechnen Sie die Kovarianzmatrizen fuer die Korrelationen 
% rho1 = 0.1, rho2 = 0.5, rho3 = 0.9 und rho4 = 1
% Diagonalisieren Sie die Kovarianzmatrizen (Matlab: eig). Berechnen Sie
% jeweils die Spur (Summe der Diagonalelemente bzw. der Eigenwerte) der
% resultierenden Diagonalmatrizen und vergleichen Sie diese mit der Spur
% der Originalmatrix.
% Welcher Zusammenhang besteht zwischen der Korrelation und 
%    - der erhaltenen Eigenwerte
%    - der Orientierung der Eigenvektoren
%    - der Invertierbarkeit der Kovarianzmatrix

clear;
close all;

% Korrelationskoeffizienten
rho1 = 0.1;
rho2 = 0.5;
rho3 = 0.9;
rho4 = 1;

% Varianzen
var1 = 2;
var2 = 7;

% Corr(X,Y) = Cov(X,Y)/sqrt(Var(X)*Var(Y))
cov1 = rho1*sqrt(var1*var2);
cov2 = rho2*sqrt(var1*var2);
cov3 = rho3*sqrt(var1*var2);
cov4 = rho4*sqrt(var1*var2);

% Kovarianzmatrix: Diagonale Varianzen, sonst cov (symmetrisch)
COV1 = [var1 cov1; cov1, var2]
COV2 = [var1 cov2; cov2, var2]
COV3 = [var1 cov3; cov3, var2]
COV4 = [var1 cov4; cov4, var2]

% bei allen gleich, weil Summe der Varianzen
spur_orig = var1+var2;

[V1, D1] = eig(COV1)
[V2, D2] = eig(COV2)
[V3, D3] = eig(COV3)
[V4, D4] = eig(COV4)

% Spur ist Summe der Diagonalelemente
spur1 = D1(1,1) + D1(2,2);
spur2 = D2(1,1) + D2(2,2);
spur3 = D3(1,1) + D3(2,2);
spur4 = D4(1,1) + D4(2,2);

numSamples = 30;
mu=[0 0];
X1=mvnrnd(mu, COV1, numSamples);
X2=mvnrnd(mu, COV2, numSamples);
X3=mvnrnd(mu, COV3, numSamples);
X4=mvnrnd(mu, COV4, numSamples);

figure
plot(X1(:,1), X1(:,2), 'b.')
hold on
h1 = plot([0,sqrt(D1(1,1))*V1(1,1)], [0, sqrt(D1(1,1))*V1(2,1)], 'b-');
h2 = plot([0,sqrt(D1(2,2))*V1(2,1)], [0, sqrt(D1(2,2))*V1(2,2)], 'r-');
hold off
axis equal
h = [h1 h2];
legend(h, 'sqrt(\lambda_1)*e_1', 'sqrt(\lambda_2)*e_2')
title('Eigenvectors for Covariance matrix to \rho1 = 0.1')

figure
plot(X2(:,1), X2(:,2), 'b.')
hold on
h1 = plot([0,sqrt(D2(1,1))*V2(1,1)], [0, sqrt(D2(1,1))*V2(2,1)], 'b-');
h2 = plot([0,sqrt(D2(2,2))*V2(2,1)], [0, sqrt(D2(2,2))*V2(2,2)], 'r-');
hold off
axis equal
h = [h1 h2];
legend(h, 'sqrt(\lambda_1)*e_1', 'sqrt(\lambda_2)*e_2')
title('Eigenvectors for Covariance matrix to \rho2 = 0.5')

figure
plot(X3(:,1), X3(:,2), 'b.')
hold on
h1 = plot([0,sqrt(D3(1,1))*V3(1,1)], [0, sqrt(D3(1,1))*V3(2,1)], 'b-');
h2 = plot([0,sqrt(D3(2,2))*V3(2,1)], [0, sqrt(D3(2,2))*V3(2,2)], 'r-');
hold off
axis equal
h = [h1 h2];
legend(h, 'sqrt(\lambda_1)*e_1', 'sqrt(\lambda_2)*e_2')
title('Eigenvectors for Covariance matrix to \rho3 = 0.9')

figure
plot(X4(:,1), X4(:,2), 'b.')
hold on
h1 = plot([0,sqrt(D4(1,1))*V4(1,1)], [0, sqrt(D4(1,1))*V4(2,1)], 'b-');
h2 = plot([0,sqrt(D4(2,2))*V4(2,1)], [0, sqrt(D4(2,2))*V4(2,2)], 'r-');
hold off
axis equal
h = [h1 h2];
legend(h, 'sqrt(\lambda_1)*e_1', 'sqrt(\lambda_2)*e_2')
title('Eigenvectors for Covariance matrix to \rho4 = 1.0')

inv(COV4)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Z-Standardisiert
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Varianzen
var1 = 1;
var2 = 1;
% Corr(X,Y) = Cov(X,Y)
cov1 = rho1;
cov2 = rho2;
cov3 = rho3;
cov4 = rho4;

% Kovarianzmatrix: Diagonale Varianzen, sonst cov (symmetrisch)
COV1_stand = [var1 cov1; cov1, var2]
COV2_stand = [var1 cov2; cov2, var2]
COV3_stand = [var1 cov3; cov3, var2]
COV4_stand = [var1 cov4; cov4, var2]

% bei allen gleich, weil Summe der Varianzen
spur_orig = var1+var2;

[V1_stand, D1_stand] = eig(COV1_stand)
[V2_stand, D2_stand] = eig(COV2_stand)
[V3_stand, D3_stand] = eig(COV3_stand)
[V4_stand, D4_stand] = eig(COV4_stand)

% Spur ist Summe der Diagonalelemente
spur1 = D1(1,1) + D1(2,2);
spur2 = D2(1,1) + D2(2,2);
spur3 = D3(1,1) + D3(2,2);
spur4 = D4(1,1) + D4(2,2);

numSamples = 30;
mu=[0 0];
X1=mvnrnd(mu, COV1_stand, numSamples);
X2=mvnrnd(mu, COV2_stand, numSamples);
X3=mvnrnd(mu, COV3_stand, numSamples);
X4=mvnrnd(mu, COV4_stand, numSamples);

figure
plot(X1(:,1), X1(:,2), 'b.')
hold on
h1 = plot([0,sqrt(D1_stand(1,1))*V1_stand(1,1)], [0, sqrt(D1_stand(1,1))*V1_stand(2,1)], 'b-');
h2 = plot([0,sqrt(D1_stand(2,2))*V1_stand(2,1)], [0, sqrt(D1_stand(2,2))*V1_stand(2,2)], 'r-');
hold off
axis equal
h = [h1 h2];
legend(h, 'sqrt(\lambda_1)*e_1', 'sqrt(\lambda_2)*e_2')
title('Eigenvectors for Covariance matrix to \rho1 = 0.1 (z-standardized)')

figure
plot(X2(:,1), X2(:,2), 'b.')
hold on
h1 = plot([0,sqrt(D2_stand(1,1))*V2_stand(1,1)], [0, sqrt(D2_stand(1,1))*V2_stand(2,1)], 'b-');
h2 = plot([0,sqrt(D2_stand(2,2))*V2_stand(2,1)], [0, sqrt(D2_stand(2,2))*V2_stand(2,2)], 'r-');
hold off
axis equal
h = [h1 h2];
legend(h, 'sqrt(\lambda_1)*e_1', 'sqrt(\lambda_2)*e_2')
title('Eigenvectors for Covariance matrix to \rho2 = 0.5 (z-standardized)')

figure
plot(X3(:,1), X3(:,2), 'b.')
hold on
h1 = plot([0,sqrt(D3_stand(1,1))*V3_stand(1,1)], [0, sqrt(D3_stand(1,1))*V3_stand(2,1)], 'b-');
h2 = plot([0,sqrt(D3_stand(2,2))*V3_stand(2,1)], [0, sqrt(D3_stand(2,2))*V3_stand(2,2)], 'r-');
hold off
axis equal
h = [h1 h2];
legend(h, 'sqrt(\lambda_1)*e_1', 'sqrt(\lambda_2)*e_2')
title('Eigenvectors for Covariance matrix to \rho3 = 0.9 (z-standardized)')

figure
plot(X4(:,1), X4(:,2), 'b.')
hold on
h1 = plot([0,sqrt(D4_stand(1,1))*V4_stand(1,1)], [0, sqrt(D4_stand(1,1))*V4_stand(2,1)], 'b-');
h2 = plot([0,sqrt(D4_stand(2,2))*V4_stand(2,1)], [0, sqrt(D4_stand(2,2))*V4_stand(2,2)], 'r-');
hold off
axis equal
h = [h1 h2];
legend(h, 'sqrt(\lambda_1)*e_1', 'sqrt(\lambda_2)*e_2')
title('Eigenvectors for Covariance matrix to \rho4 = 1.0 (z-standardized)')

% Invertierbarkeit bei Korrelation 1
inv(COV4_stand)