
% Aufgabe UE-8
% Korrelationskoeffizient einer bivariaten Normalverteilung

clear;

% 300 Samples fuer bivariante Normalverteilung

M = [4 7];
sigma_1_2 = -0.5 * sqrt(12) * sqrt(2);
SIGMA = [12 sigma_1_2; sigma_1_2 2];
samples = mvnrnd(M, SIGMA, 300);


% Z-normalisierte Werte berechnen

mu = mean(samples, 1);  % Mittelwert
s = std(samples, 0, 1);  % Standardabweichung
z_norm = (samples - repmat(mu,300,1)) ./ repmat(s,300,1);


% Normalverteilungen plotten

figure
axis equal
subplot(2,1,1);
plot(samples(:,1), samples(:,2), 'r*');
axis([-6 14 -4 12]);
subplot(2,1,2);
plot(z_norm(:,1), z_norm(:,2), 'g*');
axis([-6 14 -4 12]);


% Korrelationskoeffizient fr originale Samples

% Schtzung
mu_s = samples - repmat(mu, 300, 1);
kovmatrix = (mu_s' * mu_s) / 299;
korr_sampl_estimate = kovmatrix(1,2) ./ ( sqrt(kovmatrix(1,1) * kovmatrix(2,2)) )

% Matlab
korrmatrix = corrcoef(samples);
korr_sampl_matlab = korrmatrix(1,2)


% Korrelationskoeffizient fr z-normalisierte Samples

% Schtzung
mu = mean(z_norm, 1);
mu_s = z_norm - repmat(mu, 300, 1);
kovmatrix_z = (mu_s' * mu_s) / 299;
korr_znorm_estimate = kovmatrix_z(1,2) ./ ( sqrt(kovmatrix_z(1,1) * kovmatrix_z(2,2)) )

% Matlab
korrmatrix_z = corrcoef(z_norm);
korr_znorm_matlab = korrmatrix_z(1,2)



% -----------------------------------------------------------------------

% Aufgabe UE-9
% Rayleigh-Quotient

% Richtungsvektor berechnen:
grad = [0:2*pi/360:2*pi];  % fr die Rotation
w = [sin(grad); cos(grad)]';  % Richtungsvektor

% Initialisieren:
rwkov = zeros(1, 361);
rwkorr = zeros(1, 361);

% Rayleigh-Quotient fr die beiden Matrizen berechnen:
for i=1:361
  rwkov(i) = (w(i,:) * kovmatrix * w(i,:)') ./ (w(i,:) * w(i,:)');
  rwkorr(i) = (w(i,:) * korrmatrix * w(i,:)') ./ (w(i,:) * w(i,:)');
end

% Rayleigh-Quotient plotten

x1 = rwkov' .* w(:,1);
y1 = rwkov' .* w(:,2);
x2 = rwkorr' .* w(:,1);
y2 = rwkorr' .* w(:,2);

figure
axis equal
plot(x1, y1, 'r');
hold on;
plot(x2, y2, 'g');
hold on;


% Eigenvektoren berechnen

[V_kov, D_kov] = eig(kovmatrix)
[V_korr, D_korr] = eig(korrmatrix)

% Eigenvektoren plotten

x1 = V_kov(:,1) .* D_kov(1,1);
y1 = V_kov(:,2) .* D_kov(2,2);
x2 = V_korr(:,1) .* D_korr(1,1);
y2 = V_korr(:,2) .* D_korr(2,2);

plot([x1(1);0], [x1(2);0], 'b-');
hold on
plot([y1(1);0], [y1(2);0], 'b-');
hold on
plot([0;x2(1)], [0;x2(2)], 'm-');
hold on
plot([0;y2(1)], [0;y2(2)], 'm-');
hold off

figure
axis equal

x1 = V_kov(:,1) .* D_kov(1,1);
y1 = V_kov(:,2) .* D_kov(2,2);
x2 = V_korr(:,1) .* D_korr(1,1);
y2 = V_korr(:,2) .* D_korr(2,2);

plot([0;x1(1)], [0;x1(2)], 'b-');
hold on
plot([0;y1(1)], [0;y1(2)], 'b-');
hold on
plot([0;x2(1)], [0;x2(2)], 'm-');
hold on
plot([0;y2(1)], [0;y2(2)], 'm-');
hold off



