% Aufgabe 7

% Laden der Datenstze x und y
% x hat Dimension(2,10)
% y hat Dimension(3,10)
load 'data1.mat'
size_x = size(x)
size_y = size(y)

% Empirische Mittelwerte
% (#,2) da Unterscheidung nach Spalten
mean_x = mean(x,2)
mean_y = mean(y,2)

% Xs ... X~
% Ys ... Y~
Xs = x
Ys = y

for i = 1:size_x(1)
    Xs(i,:) = x(i,:) - mean_x(i)    
end

for i = 1:size_y(1)
    Ys(i,:) = y(i,:) - mean_y(i)
end

% Covarianz nach Formel 112
sum_x = 0
sum_y = 0

for i = 1:size_x(2)
   sum_x = sum_x + xs(:,i) * xs(:,i)'
end

for i = 1:size_y(2)
   sum_y = sum_y + ys(:,i) * ys(:,i)'
end
cov_x112 = (1/(size_x(2)-1)) * sum_x
cov_y112 = (1/(size_y(2)-1)) * sum_y

% Covarianz nach Formel 113
cov_x113 = (1/(size_x(2)-1)) * xs * xs'
cov_y113 = (1/(size_y(2)-1)) * ys * ys'

% Covarianz mittels Matlab
cov_x = cov(x')
cov_y = cov(y')

% Vergleich ber Differenzen
disp('Covarianz Matlab -  Covarianz nach Formel 112')
disp('Fr x')
cov_x - cov_x112
disp('Fr y')
cov_y - cov_y112
disp('Covarianz Matlab -  Covarianz nach Formel 113')
disp('Fr x')
cov_x - cov_x113
disp('Fr y')
cov_y - cov_y113