clear

% Aufgabe 6
% Berechnung und Plottung von dem conditional und overall risk mit
% verschiedenen Entscheidungsgrenzen

% ----------------------------------------------------------------------
% Daten der Normalverteilungen
% Wenn zwei andere Normalverteilungen verwendet werden sollen, einfach 
% hier die Daten ndern (m entspricht den Mittelwerten, s den Sigmas).

%class conditional pdfs
m = [4; 6];
s = [1; 1];
x_stern=4;

% loss-Funtion
% Reihen: unsere Entscheidung,  Spalten: wirkliche Klassengehrigkeit
lambda=[0 1; 1 0];  %symmetrischer Fall
%lambda=[0 5; 1 0]; %asymmetrischer Fall

%aprioris - Reihen: Klassen,  Spalten: task1/2
apriori=[0.5, 0.9; 0.5, 0.1];
x_stern2=ones(1,2);

%--------------------------------------------------------------------------
for task=1:2;

t=0; t2=0; alfa=0;
x = ones(1,250);
y = ones(1,250);
y2 = ones(1,250);
p = ones(1,250);
R_cond = ones(1,250);
R_cond_bayes = ones(1,250);
d = false;
erste2alfa=0;

%--------------------------------------------------------------------------
for i = 1:250;
    t = (d - m(1)) / s(1);
    t2= (d - m(2)) / s(2);
    x(i) = d;
    
    %class conditional pdfs
    y(i) = lambda(2, 1).* apriori(1,task).* normpdf(t);
    y2(i) = lambda(1, 2).*apriori(2,task).* normpdf(t2);
    
    %evidence
    p(i) = normpdf(t).* apriori(1,task) + normpdf(t2) .* apriori(2,task);
    
    %alfa
    if (d<x_stern)  alfa=1; else alfa= 2; end
    
    %conditional risk
    R_cond(i)=lambda(alfa, 1).* normpdf(t).* apriori(1,task)./p(i) + lambda(alfa, 2).* normpdf(t2).*apriori(2,task)./p(i);
    
    %Bayes
    if (normpdf(t)/normpdf(t2) > (apriori(2,task)*lambda(1,2))/(apriori(1,task)*lambda(2,1)) ) alfa=1; else alfa= 2; end;
    if (erste2alfa==false && alfa==2) 
        erste2alfa=true; 
        x_stern2(task)=d - 5/250
    end
    R_cond_bayes(i)=lambda(alfa, 1).* normpdf(t).* apriori(1,task)./p(i) + lambda(alfa, 2).* normpdf(t2).*apriori(2,task)./p(i);
    
    d = d + 10/250;
end
%--------------------------------------------------------------------------

% Berechnung von dem overall risk
overallrisk = lambda(2, 1).* apriori(1,task).* (1-normcdf((x_stern - m(1)) / s(1))) + lambda(1, 2).*apriori(2,task).* normcdf((x_stern - m(2)) / s(2))
overallrisk_bayes= lambda(2, 1).* apriori(1,task).* (1-normcdf((x_stern2(task) - m(1)) / s(1))) + lambda(1, 2).*apriori(2,task).* normcdf((x_stern2(task) - m(2)) / s(2))

%----------------------PLOT---------------------------------------------------

figure
plot(x, y, 'b', x, y2, 'b', x, p, ':b', x, R_cond, ':r', x, R_cond_bayes, ':m')
hold on

% Wert von x_stern als Gerade einzeichnen:
g = ones(1,2); 
g2 = ones(1,2); 
l = ones(1,2);
g(1) = x_stern;
g(2) = x_stern;
g2(1) = x_stern2(task);
g2(2) = x_stern2(task);
l(1) = 0.0;
l(2) = 1.0;
plot(g, l, '--r', g2, l, '--m')
hold on

hold off
legend('lambda(2,1)P(w1)p(x|w1)', 'lambda(1,2)P(w2)p(x|w2)', 'evidence', 'cond. risk', 'cond. risk bayes', 'x*', 'x* bayes', 2)
if (task==1) title('Conditional Risk mit a prioris 0.5 und 0.5','FontSize',12)
else title('Conditional Risk mit a prioris 0.9 und 0.1','FontSize',12)
end

end %for cycle fr task

