/* Uebersetzerbau, SS 2006
 * Paul Staroch, 0425426
 * Gesamtbeispiel
 *
 * headerfile for code_gen.c
 */

#ifndef __CODE_GEN_H_
#define __CODE_GEN_H_

/* macro that reserves a new register and puts it on top of the stack
 * that holds the registers that have been recently used
 */
#define PUSH regstack_push(newreg())

/* macro that takes a register from the stack and sets it free if it
 * does not contain the value of an identifier
 */
#define POP freereg_noid(regstack_pop())

/* see code_gen.c on details about these procedures */
void init(void);
int get_assignment(char *name);
void free_all_registers(void);
struct intstack *int_push(struct intstack **stack, int value);
int regstack_push(int reg);
int regstack_pop(void);
void reg_save(void);
void reg_restore(void);
void setvalues(treenode *node);
int consumer_reg(void);
void do_call(int values, char *name);
void do_zero_call(int values, char *name);
void _do_call(int values, char *name, int push);
int int_pop(struct intstack **stack);
int enter_if(void);
int exit_if(void);
int enter_not(void);
int exit_not(void);
int enter_loop(treenode *node);
int exit_loop(treenode *node);
int loop_values_push(int value);
int loop_values_pop(void);
void set_if_registers(treenode *node);
void push_if_registers(void);
void set_loop_registers(treenode *node);
void loop_registers(treenode *node);
void push_loop_registers(void);
void loop_output(void);
void save_registers();
void restore_registers();
void andjump(void);
int new_identifier_reg(char *name, int reg);
int new_identifier(char *name);
int get_register(char *name);
int drop_identifier(char *name);
int freereg(int reg);
int freereg_noid(int reg);
int newreg(void);
int newreg_safe(void);
void function_header(char *name, int has_func_calls);
void function_footer(char *name);
void compiler_info(void);
void function_parameter(char *name);
void move(int reg1, int reg2);
void enter_deleted_block(void);
void exit_deleted_block(void);

/* reducer generated by bfe (or, explained in a more precise way,
 * the code.awk script)
 */
void burm_reduce(NODEPTR_TYPE this, int goalnt);

/* yacc parser and statical analysis */
extern int yyparse(void);

/* struct that describes which register holds the value of which
 * identifier
 */
struct register_assignment {
	struct register_assignment *next;
	char *name;
	int reg;
};

/* struct that stores the information which of the 32 processor
 * registers are used at a certain point of the program
 */
struct reg_data {
	struct reg_data *next;
	int reg_used[32];
	struct register_assignment *assignments;
};

/* struct for implementing a simple stack for integer values */
struct intstack {
	struct intstack *next;
	int value;
};

/* root node of the tree processed by iburg */
extern treenode *root;
/* number of warnings generated by the lex scanner */
extern int lexical_warnings;
/* number of errors found by the lex scanner */
extern int lexical_errors;
/* number of syntax errors found by the yacc parser */
extern int syntax_errors;
/* number of errors found during the statical analysis using ox's
 * attributed grammar
 */
extern int attributed_errors;
/* temporary variables for storing a register's index */
extern int reg1;
extern int reg2;
/* variable counting up when processing the arguments of a function */
extern int func_par_index;
/* array with a Boolean value for each register telling you if that
 * register is used or not
 */
extern int reg_used[32];
/* list that helps restoring registers after the end of a program
 * part that limits an identifier's scope
 */
extern struct reg_data *reg_data_stack;
/* number of values flowing from left to right at an assignment
 * operator (->)
 */
extern int valuecount;
/* index of the innermost if block */
extern int ifcounter;
/* index of the innermost loop */
extern int loopcounter;
/* index of the innermost negation */
extern int negcounter;
/* maximum index of an if block used by now */
extern int maxif;
/* maximum index of a loop used by now */
extern int maxloop;
/* maximum index of a negation used by now */
extern int maxneg;
/* stack that holds the register indices for the output of all
 * nested if blocks
 */
extern struct intstack *if_stack;
/* stack that holds the register indices for the output of all
 * nested loops
 */
extern struct intstack *loop_stack;
/* struct that holds the indices of the registers that store the
 * values that are taken from the end of a loop back to its beginning
 */
extern struct intstack *loop_input_stack;
/* struct that holds the registers currently being in use */
extern struct intstack *reg_stack;
/* struct that stores the information about which register stores
 * the value of which identifier
 */
extern struct register_assignment *register_assignments;
/* struct that holds the number of all values that are
 * flowing into a loop
 */
extern struct intstack *loop_input_values;
/* stack that holds the indices of all nested if blocks */
extern struct intstack *ifstack;
/* stack that holds the indices of all nested loops */
extern struct intstack *loopstack;
/* stack that holds the indices of all nested negations */
extern struct intstack *negstack;
/* holds a Boolean value telling you if the function that is
 * processed currently calls another function (in that case, the
 * registers from 16 to 21 need to be saved)
 */
extern int has_call;
/* stream used for output */
extern FILE *output;
/* stream for output to /dev/null */
extern FILE *null;
/* variable that is 1 when the output should be printed to the
 * standard output
 * whenever an if block that will be discarded due to optimization,
 * the value of this variable is decremented by 1; if such an if
 * block is left, this variable is incremened by 1.
 * as long as this variable is <1, the whole output by the compiler
 * will be put to /dev/null
 */
extern int standard_output;

#endif /* __CODE_GEN_H_ */

