	/* Uebersetzerbau, SS 2006
	 * Paul Staroch, 0425426
	 * Optimierende Codeerzeugung
	 *
	 * lex-scanner
	 */

	/* necessary for LONG_MIN and LONG_MAX */
	#include <limits.h>

	#define SCANNER

	#include "parser.h"
	#include "tree.h"

	/* error writing macros */
	#define ERROR2(message1, message2) lexical_errors++; \
		fprintf(stderr, "Line %i: %s - %s\n", line_number, message1, \
		message2);
		
	#define ERROR(message) lexical_errors++; fprintf(stderr, "Line %i: %s\n", \
		line_number, message);
	
	#define ERR_INVALID_NUMBER(number) ERROR2("Invalid number", number)
	#define ERR_ILLEGAL_CHAR if(!illegal_character) \
		{ \
			ERROR("Illegal character") \
			illegal_character=1; \
		}
		
	#define ERR_COMMENT_EOF(startline) lexical_errors++; \
		fprintf(stderr, \
		"Line %i: EOF inside comment started at line %i\n", \
		line_number, startline);

	/* macros for warnings */
	#define WARN_NESTED_COMMENT(startline) lexical_warnings++; \
		fprintf(stderr, \
		"Line %i: Possibly nested comment (%s%i)\n", line_number, \
		"comment aleady started at line ", startline);

	extern int lexical_errors;
	extern int lexical_warnings;

	int illegal_character=0;	/* 	is 1 when there are several unknown
						characters next to each other */
	int line_number=1;
	int comment_startline=-1;

WHITESPACE	[ \t\r]+
NEWLINE		\n
IDENTIFIER	[_[:alpha:]][_[:alnum:]]*
NUMBER		[0-9]*
ANYCHAR		.
COMMENT_START	\/\*
COMMENT_END	\*\/

%x COMMENT
%%

{COMMENT_START}			{	/* begin of comment */
					BEGIN(COMMENT);
					
					comment_startline=line_number;
				}

<COMMENT>{COMMENT_END}		{	/* end of comment */
					BEGIN(INITIAL);

					/* new illegal character after comment */
					illegal_character=0;
				}

<COMMENT>{NEWLINE}		{	/* just to count lines inside comment */
					line_number++;
				}
				
<COMMENT>{COMMENT_START}	{	/* nested comment? */
					WARN_NESTED_COMMENT(comment_startline)
				}
		
<COMMENT><<EOF>>		{	/* EOF inside comment */
					ERR_COMMENT_EOF(comment_startline)
					exit(1);
				}
			
<COMMENT>.			/* ignore everything inside comment */

{WHITESPACE}			/* ignore spaces, tabs, LF */

{NEWLINE}			{	/* count lines */
					line_number++;

					/* new line -> new illegal character */
					illegal_character=0;
				}
					
{NUMBER}			return(NUM); @{ {
					char* p=(char*)malloc(yyleng+1);
					(void)strcpy(p,yytext);
					@NUM.value@=p;
				} @}

func				return(FUNC);
end				return(END);
if				return(IF);
then				return(THEN);
else				return(ELSE);
exit				return(EXIT);
start				return(START);
repeat				return(REPEAT);
not				return(NOT);
and				return(AND);

";"				return(';');
"("				return('(');
")"				return(')');
","				return(',');
"*"				return('*');
"+"				return('+');
"-"				return('-');
">"				return('>');
"="				return('=');
"->"				return(ASSIGN);

{IDENTIFIER}			return(ID); @{ {
					char* p=(char*)malloc(yyleng+1);
					(void)strcpy(p,yytext);
					@ID.name@=p;
				} @}
				
{ANYCHAR}			{	/* error when anything else appears */
					ERR_ILLEGAL_CHAR
				}
			
%%

