%{
		/* Uebersetzerbau, SS 2006
		 * Paul Staroch, 0425426
		 * Optimierende Codeerzeugung
		 *
		 * yacc-parser
		 */

		#define ERROR(message) { \
				(void)fprintf(stderr,"%s\n",message); \
				(void)fflush(stderr); \
				attributed_errors++; \
			}
			
		#include <stdio.h>

		#include "symbol_table.h"
		#include "tree.h"
		
		int syntax_errors=0;
		int lexical_errors=0;
		int lexical_warnings=0;
		int attributed_errors=0;

		treenode *root;

		void check_in_loop(int in_loop) {
			if(0==in_loop) {
				ERROR("IF-EXIT outside loop");
			}
		}

		void check_ifexit_count(int ifexit_count) {
			if(0==ifexit_count) {
				ERROR("Loop without IF-EXIT");
			}
		}

		void check_value_count(int val1, int val2) {
			if(val1!=val2) {
				ERROR("Error in data stream");
			}
		}

		void check_ifexit_value_count(int ifexit_value_count1, int ifexit_count1, int ifexit_value_count2, int ifexit_count2) {
			if(ifexit_count1>0 && ifexit_count2>0) {
				if(ifexit_value_count1!=ifexit_value_count2) {
					ERROR("Different output value count of IF-EXIT-statements");
				}
			}
		}
		/* has_func_call attribute: Term, Expr */
%}

%start		Program

%token		NUM ID ASSIGN
%token		FUNC END IF THEN ELSE EXIT START REPEAT AND NOT

@autoinh inloop input_table input_values 
@autosyn ifexit_count output_table output_values ifexit_value_count has_func_call

@attributes {struct symbol_t *input_table; treenode *node; int has_func_call;} Bool Bterms Bterm Term Expr Plusterm Malterm
@attributes {struct symbol_t *input_table; int ifexit_value_count; treenode *node; int has_func_call;} Ifexit
@attributes {struct symbol_t *input_table; int output_values; treenode *node; int has_func_call;} Exprs
@attributes {struct symbol_t *input_table; int input_values; int output_values; treenode *node; int has_func_call;} Loop
@attributes {struct symbol_t *output_table; treenode *node;} Ids MoreIds
@attributes {struct symbol_t *input_table; struct symbol_t *output_table; int input_values; treenode *node; int has_func_call;} Consumers
@attributes {struct symbol_t *input_table; struct symbol_t *output_table; treenode *node; int has_func_call;} Consumer
@attributes {struct symbol_t *input_table; struct symbol_t *output_table; int inloop; int ifexit_count; int ifexit_value_count; int input_values; int output_values; treenode *node; int has_func_call;} Trans Tran
@attributes {struct symbol_t *input_table; int inloop; int ifexit_count; int ifexit_value_count; int input_values; int output_values; treenode *node; int has_func_call;} Prod Prodtrans If
@attributes {struct symbol_t *input_table; int ifexit_count; int ifexit_value_count; treenode *node; int has_func_call;} IfexitGroup
@attributes {char *name;} ID
@attributes {char *value;} NUM
@attributes {treenode *node;} Program
@attributes {treenode *node; int has_func_call;} Funcdef

@traversal @postorder t

%%
Program:	  Funcdef ';' Program
		@{ @i @Program.0.node@=new_node(OP_Program, @Funcdef.node@, @Program.1.node@);
		   @t root=@Program.0.node@;
		@}
		
		| /* empty */
		@{ @i @Program.0.node@=new_leaf(OP_Empty);
		@}
		
		;

Funcdef:	  FUNC ID '(' Ids ')' Prodtrans END
		@{ @i @Prodtrans.input_table@ = @Ids.output_table@;
		   @i @Prodtrans.inloop@ = 0;
		   @i @Prodtrans.input_values@ = 0;

		   @i @Funcdef.node@ = new_named_node_values(OP_Funcdef, @Ids.node@, @Prodtrans.node@, @ID.name@, @Funcdef.has_func_call@);

		   @t check_value_count(@Prodtrans.output_values@,1);
		@}
		
		;

Ids:		  ID
		@{ @i @Ids.output_table@ = table_add_symbol(new_table(), @ID.name@);
		
		   @i @Ids.node@ = new_named_leaf(OP_Id, @ID.name@);
		@}
		
		| ID MoreIds
		@{ @i @Ids.output_table@ = table_add_symbol(@MoreIds.output_table@, @ID.name@);
		
		   @i @Ids.node@ = new_node(OP_Ids, new_named_leaf(OP_Id, @ID.name@), @MoreIds.node@);
		@}
		
		;

MoreIds:	  ',' ID
		@{ @i @MoreIds.output_table@ = table_add_symbol(new_table(), @ID.name@);
		
		   @i @MoreIds.node@ = new_named_leaf(OP_Id, @ID.name@);
		@}
		
		| ',' ID MoreIds
		@{ @i @MoreIds.output_table@ = table_add_symbol(@MoreIds.1.output_table@, @ID.name@);
		
		   @i @MoreIds.node@ = new_node(OP_Ids, new_named_leaf(OP_Id, @ID.name@), @MoreIds.1.node@);
		@}
		
		;
		
Prod:		  Exprs ASSIGN
		@{ @i @Prod.ifexit_count@ = 0;
		   @i @Prod.ifexit_value_count@ = 0;

		   @i @Prod.node@ = @Exprs.node@;
		@}
		
		| If ASSIGN
		@{ @i @Prod.node@ = @If.node@;
		@}
		
		;

Prodtrans:	  Prod
		@{ @i @Prodtrans.node@ = @Prod.node@;
		@}
		
		| Prod Trans 
		@{ @i @Prodtrans.ifexit_count@ = @Prod.ifexit_count@ + @Trans.ifexit_count@;
		   @i @Trans.input_values@ = @Prod.output_values@;
		   @i @Prodtrans.output_values@ = @Trans.output_values@;
		   @i @Prodtrans.ifexit_value_count@ = @Prod.ifexit_value_count@ > @Trans.ifexit_value_count@ ? @Prod.ifexit_value_count@ : @Trans.ifexit_value_count@;

		   @i @Prodtrans.node@ = new_node(OP_Prodtrans, @Prod.node@, @Trans.node@);
		   @i @Prodtrans.has_func_call@ = @Prod.has_func_call@ || @Trans.has_func_call@;
		   
		   @t check_ifexit_value_count(@Prod.ifexit_value_count@, @Prod.ifexit_count@, @Trans.ifexit_value_count@, @Trans.ifexit_count@);
		@}
		
		;

Trans:		  Tran
		@{ @i @Trans.node@ = @Tran.node@;
		@}

		| Tran Trans
		@{ @i @Tran.input_table@ = @Trans.input_table@;
		   @i @Trans.1.input_table@ = @Tran.output_table@;
		   @i @Trans.output_table@ = @Trans.1.output_table@;
		   @i @Trans.ifexit_count@ = @Tran.ifexit_count@ + @Trans.1.ifexit_count@;
		   @i @Tran.input_values@ = @Trans.input_values@;
		   @i @Trans.1.input_values@ = @Tran.output_values@;
		   @i @Trans.output_values@ = @Trans.1.output_values@;
		   @i @Trans.ifexit_value_count@ = @Tran.ifexit_value_count@ > @Trans.1.ifexit_value_count@ ? @Tran.ifexit_value_count@ : @Trans.1.ifexit_value_count@;

		   @i @Trans.node@ = new_node(OP_Trans, @Tran.node@, @Trans.1.node@);
		   @i @Trans.has_func_call@ = @Tran.has_func_call@ || @Trans.1.has_func_call@;
		   
		   @t check_ifexit_value_count(@Tran.ifexit_value_count@, @Tran.ifexit_count@, @Trans.1.ifexit_value_count@, @Trans.1.ifexit_count@);
		@}
		
		;

Tran:		  Loop ASSIGN
		@{ @i @Loop.input_table@ = clone_table(@Tran.input_table@);
		   @i @Tran.output_table@ = @Tran.input_table@;
		   @i @Tran.ifexit_count@ = 0;
		   @i @Tran.ifexit_value_count@ = 0;

		   @i @Tran.node@ = @Loop.node@;
		@}

		| Consumers ';' Prod
		@{ @i @Consumers.input_table@ = clone_table(@Tran.input_table@);
		   @i @Prod.input_table@ = @Consumers.output_table@;

		   @i @Tran.node@ = new_node(OP_Tran, @Consumers.node@, @Prod.node@);
		   @i @Tran.has_func_call@ = @Consumers.has_func_call@ || @Prod.has_func_call@;
		@}
		
		| Consumers ';' IfexitGroup Prod
		@{ @i @Consumers.input_table@ = clone_table(@Tran.input_table@);
		   @i @IfexitGroup.input_table@ = @Consumers.output_table@;
		   @i @Prod.input_table@ = @Consumers.output_table@;
		   @i @Tran.output_table@ = @Consumers.output_table@;
		   @i @Tran.ifexit_count@ = @IfexitGroup.ifexit_count@ + @Prod.ifexit_count@;
		   @i @Tran.ifexit_value_count@ = @IfexitGroup.ifexit_value_count@ > @Prod.ifexit_value_count@ ? @IfexitGroup.ifexit_value_count@ : @Prod.ifexit_value_count@;

		   @i @Tran.node@ = new_node(OP_Tran, @Consumers.node@, new_node(OP_Ifexits, @IfexitGroup.node@, @Prod.node@));
		   @i @Tran.has_func_call@ = @Consumers.has_func_call@ || @IfexitGroup.has_func_call@ || @Prod.has_func_call@;
		   
		   @t check_in_loop(@Tran.inloop@);
		   @t check_ifexit_value_count(@IfexitGroup.ifexit_value_count@, @IfexitGroup.ifexit_count@, @Prod.ifexit_value_count@, @Prod.ifexit_count@);
		@}
		
		;

IfexitGroup:	  Ifexit ';'
		@{ @i @IfexitGroup.ifexit_count@ = 1;

		   @i @IfexitGroup.node@ = @Ifexit.node@;
		@}
		
		| IfexitGroup Ifexit ';'
		@{ @i @IfexitGroup.ifexit_count@ = @IfexitGroup.1.ifexit_count@ + 1;
		   @i @IfexitGroup.ifexit_value_count@ = @IfexitGroup.1.ifexit_value_count@;

		   @i @IfexitGroup.node@ = new_node(OP_Ifexitg, @IfexitGroup.1.node@, @Ifexit.node@);
		   @i @IfexitGroup.has_func_call@ = @IfexitGroup.1.has_func_call@ || @Ifexit.has_func_call@;
		   
		   @t check_ifexit_value_count(@IfexitGroup.1.ifexit_value_count@, @IfexitGroup.1.ifexit_count@, @Ifexit.ifexit_value_count@, 1);
		   @t @IfexitGroup.has_func_call@ = @IfexitGroup.has_func_call@ || @Ifexit.has_func_call@;
		@}

		;
		
If:		  IF Bool THEN Prodtrans ELSE Prodtrans END
		@{ @i @Prodtrans.input_table@ = clone_table(@If.input_table@);
		   @i @Prodtrans.1.input_table@ = clone_table(@If.input_table@);
		   @i @If.ifexit_count@ = @Prodtrans.ifexit_count@ + @Prodtrans.1.ifexit_count@;
		   @i @If.output_values@ = @Prodtrans.output_values@;
		   @i @If.ifexit_value_count@ = @Prodtrans.ifexit_value_count@ > @Prodtrans.1.ifexit_value_count@ ? @Prodtrans.ifexit_value_count@ : @Prodtrans.1.ifexit_value_count@;
		   
		   @i @If.node@ = new_node_values(OP_If, @Bool.node@, new_node(OP_If_branches, @Prodtrans.node@, new_node(OP_If_else, @Prodtrans.1.node@, (treenode *)NULL)), @If.output_values@);
		   @i @If.has_func_call@ = @Bool.has_func_call@ || @Prodtrans.has_func_call@ || @Prodtrans.1.has_func_call@;

		   @t check_value_count(@Prodtrans.output_values@, @Prodtrans.1.output_values@);
		   @t check_ifexit_value_count(@Prodtrans.ifexit_value_count@, @Prodtrans.ifexit_count@, @Prodtrans.1.ifexit_value_count@, @Prodtrans.1.ifexit_count@);
		@}
		
		;

Ifexit:		  IF Bool THEN Prodtrans EXIT
		@{ @i @Prodtrans.input_table@ = clone_table(@Ifexit.input_table@);
		   /* we must be inside a loop because Ifexit may only appear inside a loop */
		   @i @Prodtrans.inloop@ = 1;
		   @i @Prodtrans.input_values@ = 0;
		   @i @Ifexit.ifexit_value_count@ = @Prodtrans.output_values@;

		   @i @Ifexit.node@ = new_node(OP_Ifexit, @Bool.node@, new_node(OP_Ifexit_branch, @Prodtrans.node@, (treenode *)NULL));
		   @i @Ifexit.has_func_call@ = @Bool.has_func_call@ || @Prodtrans.has_func_call@;

		   @t check_ifexit_value_count(@Prodtrans.ifexit_value_count@, @Prodtrans.ifexit_count@, @Ifexit.ifexit_value_count@, 1);
		@}
		
		;

Loop:		  START ASSIGN Trans REPEAT
		@{ @i @Trans.inloop@ = 1;
		   @i @Loop.output_values@ = @Trans.ifexit_value_count@;
		   
		   @i @Loop.node@ = new_node_values(OP_Loop, @Trans.node@, (treenode *)NULL, @Loop.output_values@);

		   @t check_ifexit_count(@Trans.ifexit_count@); 
		   @t check_value_count(@Trans.input_values@, @Trans.output_values@);
		@}
		
		| START ASSIGN REPEAT
		@{ @i @Loop.output_values@ = @Loop.input_values@;

		   @i @Loop.node@ = new_leaf(OP_Loop);
		   @i @Loop.has_func_call@ = 0;

		   @t check_ifexit_count(0);
		@}

		;

Consumers:	  Consumer
		@{ @i @Consumers.output_table@ = table_merge(@Consumers.input_table@, @Consumer.output_table@);

		   @i @Consumers.node@ = @Consumer.node@;
		   
		   @t check_value_count(@Consumers.input_values@, 1);
		@}
		
		| Consumer ',' Consumers
		@{ @i @Consumers.output_table@ = table_merge(@Consumers.1.output_table@, @Consumer.output_table@);
		   @i @Consumers.1.input_table@ = clone_table(@Consumers.input_table@);
		   @i @Consumers.1.input_values@ = @Consumers.input_values@ - 1;

		   @i @Consumers.node@ = new_node(OP_Consumers, @Consumer.node@, @Consumers.1.node@);
		   @i @Consumers.has_func_call@ = @Consumer.has_func_call@ || @Consumers.1.has_func_call@;

		   @t check_value_count(@Consumers.input_values@, @Consumers.1.input_values@ + 1);
		@}

		;

Consumer:	  ID
		@{ @i @Consumer.output_table@ = table_add_symbol(new_table(), @ID.name@);

		   @i @Consumer.node@ = new_named_leaf(OP_Id, @ID.name@);
		   @i @Consumer.has_func_call@ = 0;
		@}
		
		| '*' Term
		@{ @i @Consumer.output_table@ = new_table();

		   @i @Consumer.node@ = new_node(OP_Write, @Term.node@, (treenode *)NULL);
		@}

		;

Exprs:		  Expr
		@{ @i @Exprs.output_values@ = 1;

		   @i @Exprs.node@ = @Expr.node@;
		@}
		
		| Expr ',' Exprs
		@{ @i @Exprs.output_values@ = @Exprs.1.output_values@ + 1;

		   @i @Exprs.node@ = new_node_values(OP_Exprs, @Expr.node@, @Exprs.1.node@, @Exprs.output_values@);
		   @i @Exprs.has_func_call@ = @Expr.has_func_call@ + @Exprs.1.has_func_call@;
		@}

		;

Expr:		  '-' Term
		@{ @i @Expr.node@ = new_node_values(OP_Term_neg, @Term.node@, (treenode *)NULL, 1);
		@}
		
		| '*' Term
		@{ @i @Expr.node@ = new_node_values(OP_Read, @Term.node@, (treenode *)NULL, 1);
		@}

		| Plusterm Term
		@{ @i @Expr.node@ = new_node_values(OP_Term, @Plusterm.node@, @Term.node@, 1);
		   @i @Expr.has_func_call@ = @Plusterm.has_func_call@ || @Term.has_func_call@;
		@}

		| Malterm Term
		@{ @i @Expr.node@ = new_node_values(OP_Term, @Malterm.node@, @Term.node@, 1);
		   @i @Expr.has_func_call@ = @Malterm.has_func_call@ || @Term.has_func_call@;
		@}
		
		| Term
		@{ @i @Expr.node@ = @Term.node@;
		@}
		
		;

Plusterm:	  Term '+'
		@{ @i @Plusterm.node@ = new_node(OP_Plus1, @Term.node@, (treenode *)NULL);
		@}
		
		| Plusterm Term '+'
		@{ @i @Plusterm.node@ = new_node(OP_Plus2, @Plusterm.1.node@, @Term.node@);
		   @i @Plusterm.has_func_call@ = @Plusterm.1.has_func_call@ || @Term.has_func_call@;
		@}
		
		;

Malterm:	  Term '*'
		@{ @i @Malterm.node@ = new_node(OP_Mal1, @Term.node@, (treenode *)NULL);
		@}
		
		| Malterm Term '*'
		@{ @i @Malterm.node@ = new_node(OP_Mal2, @Malterm.1.node@, @Term.node@);
		   @i @Malterm.has_func_call@ = @Malterm.1.has_func_call@ || @Term.has_func_call@;
		@}

		;

Term:		  '(' Expr ')'
		@{ @i @Term.node@ = @Expr.node@;
		@}

		| NUM
		@{ @i @Term.node@ = strcmp(@NUM.value@, "0")==0 ? new_named_leaf_values(OP_Zero, "0", 1) : (strcmp(@NUM.value@, "1")==0 ? new_named_leaf_values(OP_One, "1", 1) : new_named_leaf_values(OP_Num, @NUM.value@, 1));
		   @i @Term.has_func_call@ = 0;
		@}

		| ID
		@{ @t check_symbol_defined(@Term.input_table@, @ID.name@);
		
		   @i @Term.node@ = new_named_leaf_values(OP_Id, @ID.name@, 1);
		   @i @Term.has_func_call@ = 0;
		@}
		
		| ID '(' Exprs ')'
		@{ @i @Term.node@ = new_named_node_values(OP_Call, @Exprs.node@, (treenode *)NULL, @ID.name@, 1);
		   @i @Term.has_func_call@ = 1;
		@}

		;

Bool:		  Bterm Bterms
		@{ @i @Bool.node@ = new_node(OP_Bool, @Bterm.node@, @Bterms.node@);
		   @i @Bool.has_func_call@ = @Bterm.has_func_call@ || @Bterms.has_func_call@;
		@}

		| NOT Bterm
		@{ @i @Bool.node@ = new_node(OP_Not, @Bterm.node@, (treenode *)NULL);
		@}
		
		| Bterm
		@{ @i @Bool.node@ = @Bterm.node@;
		@}

		;

Bterms:		  AND Bterm
		@{ @i @Bterms.node@ = new_node(OP_And, @Bterm.node@, (treenode *)NULL);
		@}

		| AND Bterm Bterms
		@{ @i @Bterms.node@ = new_node(OP_Bterms, new_node(OP_And, @Bterm.node@, (treenode *)NULL), @Bterms.1.node@);
		   @i @Bterms.has_func_call@ = @Bterm.has_func_call@ || @Bterms.1.has_func_call@;
		@}

		;
		
Bterm:		  Expr '>' Expr
		@{ @i @Bterm.node@ = new_node(OP_Gt, @Expr.node@, @Expr.1.node@);
		   @i @Bterm.has_func_call@ = @Expr.has_func_call@ || @Expr.1.has_func_call@;
		@}
		
		| Expr '=' Expr
		@{ @i @Bterm.node@ = new_node(OP_Equal, @Expr.node@, @Expr.1.node@);
		   @i @Bterm.has_func_call@ = @Expr.has_func_call@ || @Expr.1.has_func_call@;
		@}
		
		| '(' Bool ')'
		@{ @i @Bterm.node@ = @Bool.node@;
		@}

		;

%%

extern int yylex();
extern int line_number;

int yyerror(char *error_text) {
	(void)fprintf(stderr, "Line %i: %s\n", line_number,error_text);
	(void)fflush(stderr);
	syntax_errors++;
}

