#!/bin/bash

# Uebersetzerbau, SS 2006
# Paul Staroch, 0425426
# Optimierende Codeerzeugung

# bash script for cleaning up

dont_delete=(clean.sh code.awk code.bfe code_gen.c code_gen.h Makefile symbol_table.c symbol_table.h tree.c tree.h parser.y scanner.lex)

echo "Files to be deleted:"
filecount=0
for file in $( ls ); do
	found=0
	a=0
	while [ $a -lt ${#dont_delete[*]} ]; do
		if [ "${dont_delete[$a]}" = "$file" ]; then
			found=1
		fi
		a=$((a+1))
	done
	if [ $found -eq 0 ]; then
		echo $file
		filecount=$((filecount+1))
	fi
done
if [ $filecount -eq 0 ]; then
	echo "No files to be deleted."
	exit
fi
Option=""

while [[ "$Option" != "y" && "$Option" != "n" ]]; do
	echo "Delete these $filecount files [y/n]?"
        read Option
done
			
if [ "$Option" = "n" ]; then
	exit
fi
for file in $( ls ); do
	found=0
	a=0
	while [ $a -lt ${#dont_delete[*]} ]; do
		if [ "${dont_delete[$a]}" = "$file" ]; then
			found=1
		fi
		a=$((a+1))
	done
	if [ $found -eq 0 ]; then
		echo "Deleting $file..."
		rm $file
	fi
done

echo "Done."

