%{
		#include <stdio.h>
		int syntax_errors=0;
		int lexical_errors=0;
		int lexical_warnings=0;
%}

%start		Program

%token		NUM ID ASSIGN
%token		FUNC END IF THEN ELSE EXIT START REPEAT AND NOT

%%
Program:	  Funcdef ';' Program	
		|
		;

Funcdef:	  FUNC ID '(' Ids ')' Prodtrans END
		;

Ids:		  ID
		| ID MoreIds
		;

MoreIds:	  ',' ID
		| ',' ID MoreIds
		;
		
Prod:		  Exprs ASSIGN
		| If ASSIGN

		;

Prodtrans:	  Prod
		| Prod Trans 
		;

Trans:		  Tran
		| Tran Trans
		;

Tran:		  Loop ASSIGN
		| Consumers ';' Prod
		| Consumers ';' IfexitGroup Prod
		;

IfexitGroup:	  Ifexit ';'
		| IfexitGroup Ifexit ';'
		;
		
If:		  IF Bool THEN Prodtrans ELSE Prodtrans END
		;

Ifexit:		  IF Bool THEN Prodtrans EXIT
		;

Loop:		  START ASSIGN Trans REPEAT
		| START ASSIGN REPEAT
		;

Consumers:	  Consumer
		| Consumer ',' Consumers
		;

Consumer:	  ID
		| '*' Term
		;

Exprs:		  Expr
		| Expr ',' Exprs
		;

Expr:		  '-' Term
		| '*' Term
		| Term Plusterm
		| Term Malterm
		| Term
		;

Plusterm:	  '+' Term
		| '+' Term Plusterm
		;

Malterm:	  '*' Term
		| '*' Term Malterm
		;

Term:		  '(' Expr ')'
		| NUM
		| ID
		| ID '(' Exprs ')'
		;

Bool:		  Bterm Bterms
		| NOT Bterm
		| Bterm
		;

Bterms:		  AND Bterm
		| AND Bterm Bterms
		;
		
Bterm:		  Expr '>' Expr
		| Expr '=' Expr
		| '(' Bool ')'
		;

%%

extern int yylex();
extern int line_number;

int yyerror(char *error_text) {
	fprintf(stderr, "Line %i: %s\n", line_number,error_text);
	syntax_errors++;
}

int main(int argc, char **argv) {
	yyparse();
	if(lexical_errors>0) {
		return(1);
	}
	if(syntax_errors>0) {
		return(2);
	}
	return(0);
}


