/* Uebersetzerbau, SS 2006
 * Paul Staroch, 0425426
 * Gesamtbeispiel
 *
 * header file for tree.c
 */

#ifndef __TREE_H_
#define __TREE_H_

#ifndef CODE
typedef struct burm_state *STATEPTR_TYPE; 
#endif

enum {
	OP_Empty=1,
	OP_Program,
	OP_Funcdef,
	OP_Id,
	OP_Ids,
	OP_Prodtrans,
	OP_If,
	OP_Exprs,
	OP_Trans,
	OP_Loop,
	OP_Tran,
	OP_Ifexits,
	OP_Ifexitg,
	OP_Ifexit,
	OP_If_branches,
	OP_Consumers,
	OP_Write,
	OP_Term_neg,
	OP_Plus1,
	OP_Mal1,
	OP_Num,
	OP_Call,
	OP_Bool,
	OP_Not,
	OP_And,
	OP_Bterms,
	OP_Gt,
	OP_Equal,
	OP_Read,
	OP_Term,
	OP_If_else,
	OP_Ifexit_branch,
	OP_Plus2,
	OP_Mal2,
	OP_Zero,
	OP_One
};

#ifdef DEBUG
static char rule_names[100][100]={
	"",
        "OP_Empty",
        "OP_Program",
        "OP_Funcdef",
        "OP_Id",
        "OP_Ids",
        "OP_Prodtrans",
        "OP_If",
        "OP_Exprs",
        "OP_Trans",
        "OP_Loop",
        "OP_Tran",
        "OP_Ifexits",
        "OP_Ifexitg",
        "OP_Ifexit",
        "OP_If_branches",
        "OP_Consumers",
        "OP_Write",
        "OP_Term_neg",
        "OP_Plus1",
        "OP_Mal1",
        "OP_Num",
        "OP_Call",
        "OP_Bool",
        "OP_Not",
        "OP_And",
        "OP_Bterms",
        "OP_Gt",
        "OP_Equal",
        "OP_Read",
        "OP_Term",
	"OP_If_else",
	"OP_Ifexit_branch",
	"OP_Plus2",
	"OP_Mal2",
	"OP_Zero",
	"OP_One"
};
#endif /* DEBUG */
	  

/* struct for the tree build by ox for iburg */
typedef struct treenode {
	int op;
	struct treenode *kids[2];
	STATEPTR_TYPE label;
	char *name;
	long val;
	int values;
	struct treenode *parent;
} treenode;

typedef treenode *treenodep;

/* macros for iburg being able to traverse the tree */
#define NODEPTR_TYPE    	treenodep
#define OP_LABEL(p)     	((p)->op)
#define LEFT_CHILD(p)   	((p)->kids[0])
#define RIGHT_CHILD(p)  	((p)->kids[1])
#define STATE_LABEL(p)  	((p)->label)
#define PANIC			printf

/* see tree.c for description about these procedures */
treenode *new_node(int op, treenode *left, treenode *right);
treenode *new_node_values(int op, treenode *left, treenode *right, int values); 
treenode *new_leaf(int op);
treenode *new_named_leaf(int op, char *name);
treenode *new_named_leaf_values(int op, char *name, int values);
treenode *new_named_node(int op, treenode *left, treenode *right, char *name);
treenode *new_named_node_values(int op, treenode *left, treenode *right, char *name, int values);

#ifdef DEBUG
void write_indent(int indent);
void write_tree(treenode *node, int indent);
#endif /* DEBUG */

#endif /* __TREE_H */

