/* Uebersetzerbau, SS 2006
 * Paul Staroch, 0425426
 * Optimierende Codeerzeugung
 *
 * header file for symbol_table.c
 */

#ifndef __SYMBOL_TABLE_H
#define __SYMBOL_TABLE_H

#include <string.h>
#include <malloc.h>

/* linked list that holds a symbol table consisting of a list of identifiers */
struct symbol_t {
	char *identifier;
	struct symbol_t *next;
};

/* linked list that holds a list of symbol tables (for destruction of all
 * these lists at the end of the program execution
 */
struct tables {
        struct symbol_t *table;
        struct tables *next;
};

/* see symbol_table.c for information on procedures */
int add_to_table_list(struct symbol_t *new_table);
void remove_all_lists(void);
struct symbol_t *clone_table(struct symbol_t *table);
struct symbol_t *new_table(void);
struct symbol_t *table_add_symbol(struct symbol_t *table, char *identifier);
struct symbol_t *table_remove_symbol(struct symbol_t *table, char *identifier);
struct symbol_t *table_lookup(struct symbol_t *table, char *identifier);
void free_table(struct symbol_t *table);
int checkSymbolFree(struct symbol_t *table, char *identifier);
int checkSymbolDefined(struct symbol_t *table, char *identifier);
struct symbol_t *table_merge(struct symbol_t *table, struct symbol_t *to_add);
void print_table(struct symbol_t *table);

#endif /* __SYMBOL_TABLE_H */

