%{
		/* Uebersetzerbau SS 06
		   Attributierte Grammatik
		   Paul Staroch, 0425426

		*/

		#define ERROR(message) { \
				(void)fprintf(stderr,"%s\n",message); \
				(void)fflush(stderr); \
				attributed_errors++; \
			}
			
		#include <stdio.h>

		#include "symbol_table.h"
		
		int syntax_errors=0;
		int lexical_errors=0;
		int lexical_warnings=0;
		int attributed_errors=0;

		void check_in_loop(int in_loop) {
			if(0==in_loop) {
				ERROR("IF-EXIT outside loop");
			}
		}

		void check_ifexit_count(int ifexit_count) {
			if(0==ifexit_count) {
				ERROR("Loop without IF-EXIT");
			}
		}

		void check_value_count(int val1, int val2) {
			if(val1!=val2) {
				ERROR("Error in data stream");
			}
		}

		void check_ifexit_value_count(int ifexit_value_count1, int ifexit_count1, int ifexit_value_count2, int ifexit_count2) {
			if(ifexit_count1>0 && ifexit_count2>0) {
				if(ifexit_value_count1!=ifexit_value_count2) {
					ERROR("Different output value count of IF-EXIT-statements");
				}
			}
		}
%}

%start		Program

%token		NUM ID ASSIGN
%token		FUNC END IF THEN ELSE EXIT START REPEAT AND NOT
@autoinh inloop input_table input_values
@autosyn ifexit_count output_table output_values ifexit_value_count
@attributes {struct symbol_t *input_table;} Bool Bterms Bterm Term Expr Plusterm Malterm
@attributes {struct symbol_t *input_table; int ifexit_value_count;} Ifexit
@attributes {struct symbol_t *input_table; int output_values;} Exprs
@attributes {struct symbol_t *input_table; int input_values; int output_values;} Loop
@attributes {struct symbol_t *output_table;} Ids MoreIds
@attributes {struct symbol_t *input_table; struct symbol_t *output_table; int input_values;} Consumers
@attributes {struct symbol_t *input_table; struct symbol_t *output_table;} Consumer
@attributes {struct symbol_t *input_table; struct symbol_t *output_table; int inloop; int ifexit_count; int ifexit_value_count; int input_values; int output_values;} Trans Tran
@attributes {struct symbol_t *input_table; int inloop; int ifexit_count; int ifexit_value_count; int input_values; int output_values;} Prod Prodtrans If
@attributes {struct symbol_t *input_table; int ifexit_count; int ifexit_value_count;} IfexitGroup
@attributes {char *name;} ID
@traversal @postorder t

%%
Program:	  Funcdef ';' Program	
		|
		;

Funcdef:	  FUNC ID '(' Ids ')' Prodtrans END
		@{ @i @Prodtrans.input_table@ = @Ids.output_table@;
		   @i @Prodtrans.inloop@ = 0;
		   @i @Prodtrans.input_values@ = 0;
		   @t check_value_count(@Prodtrans.output_values@,1);
		@}
		
		;

Ids:		  ID
		@{ @i @Ids.output_table@ = table_add_symbol(new_table(), @ID.name@);
		@}
		
		| ID MoreIds
		@{ @i @Ids.output_table@ = table_add_symbol(@MoreIds.output_table@, @ID.name@);
		@}
		
		;

MoreIds:	  ',' ID
		@{ @i @MoreIds.output_table@ = table_add_symbol(new_table(), @ID.name@);
		@}
		
		| ',' ID MoreIds
		@{ @i @MoreIds.output_table@ = table_add_symbol(@MoreIds.1.output_table@, @ID.name@);
		@}
		
		;
		
Prod:		  Exprs ASSIGN
		@{ @i @Prod.ifexit_count@ = 0;
		   @i @Prod.ifexit_value_count@ = 0;
		@}
		
		| If ASSIGN
		;

Prodtrans:	  Prod

		| Prod Trans 
		@{ @i @Prodtrans.ifexit_count@ = @Prod.ifexit_count@ + @Trans.ifexit_count@;
		   @i @Trans.input_values@ = @Prod.output_values@;
		   @i @Prodtrans.output_values@ = @Trans.output_values@;
		   @i @Prodtrans.ifexit_value_count@ = @Prod.ifexit_value_count@ > @Trans.ifexit_value_count@ ? @Prod.ifexit_value_count@ : @Trans.ifexit_value_count@;
		   @t check_ifexit_value_count(@Prod.ifexit_value_count@, @Prod.ifexit_count@, @Trans.ifexit_value_count@, @Trans.ifexit_count@);
		@}
		
		;

Trans:		  Tran

		| Tran Trans
		@{ @i @Tran.input_table@ = @Trans.input_table@;
		   @i @Trans.1.input_table@ = @Tran.output_table@;
		   @i @Trans.output_table@ = @Trans.1.output_table@;
		   @i @Trans.ifexit_count@ = @Tran.ifexit_count@ + @Trans.1.ifexit_count@;
		   @i @Tran.input_values@ = @Trans.input_values@;
		   @i @Trans.1.input_values@ = @Tran.output_values@;
		   @i @Trans.output_values@ = @Trans.1.output_values@;
		   @i @Trans.ifexit_value_count@ = @Tran.ifexit_value_count@ > @Trans.1.ifexit_value_count@ ? @Tran.ifexit_value_count@ : @Trans.1.ifexit_value_count@;
		   @t check_ifexit_value_count(@Tran.ifexit_value_count@, @Tran.ifexit_count@, @Trans.1.ifexit_value_count@, @Trans.1.ifexit_count@);
		@}
		
		;

Tran:		  Loop ASSIGN
		@{ @i @Loop.input_table@ = clone_table(@Tran.input_table@);
		   @i @Tran.output_table@ = @Tran.input_table@;
		   @i @Tran.ifexit_count@ = 0;
		   @i @Tran.ifexit_value_count@ = 0;
		@}

		| Consumers ';' Prod
		@{ @i @Consumers.input_table@ = clone_table(@Tran.input_table@);
		   @i @Prod.input_table@ = @Consumers.output_table@;
		@}
		
		| Consumers ';' IfexitGroup Prod
		@{ @i @Consumers.input_table@ = clone_table(@Tran.input_table@);
		   @i @IfexitGroup.input_table@ = @Consumers.output_table@;
		   @i @Prod.input_table@ = @Consumers.output_table@;
		   @i @Tran.output_table@ = @Consumers.output_table@;
		   @t check_in_loop(@Tran.inloop@);
		   @i @Tran.ifexit_count@ = @IfexitGroup.ifexit_count@ + @Prod.ifexit_count@;
		   @i @Tran.ifexit_value_count@ = @IfexitGroup.ifexit_value_count@ > @Prod.ifexit_value_count@ ? @IfexitGroup.ifexit_value_count@ : @Prod.ifexit_value_count@;
		   @t check_ifexit_value_count(@IfexitGroup.ifexit_value_count@, @IfexitGroup.ifexit_count@, @Prod.ifexit_value_count@, @Prod.ifexit_count@);
		@}
		
		;

IfexitGroup:	  Ifexit ';'
		@{ @i @IfexitGroup.ifexit_count@ = 1;
		@}
		
		| IfexitGroup Ifexit ';'
		@{ @i @IfexitGroup.ifexit_count@ = @IfexitGroup.1.ifexit_count@ + 1;
		   @i @IfexitGroup.ifexit_value_count@ = @IfexitGroup.1.ifexit_value_count@;
		   @t check_ifexit_value_count(@IfexitGroup.1.ifexit_value_count@, @IfexitGroup.1.ifexit_count@, @Ifexit.ifexit_value_count@, 1);
		@}

		;
		
If:		  IF Bool THEN Prodtrans ELSE Prodtrans END
		@{ @i @Prodtrans.input_table@ = clone_table(@If.input_table@);
		   @i @Prodtrans.1.input_table@ = clone_table(@If.input_table@);
		   @i @If.ifexit_count@ = @Prodtrans.ifexit_count@ + @Prodtrans.1.ifexit_count@;
		   @i @If.output_values@ = @Prodtrans.output_values@;
		   @t check_value_count(@Prodtrans.output_values@, @Prodtrans.1.output_values@);
		   @i @If.ifexit_value_count@ = @Prodtrans.ifexit_value_count@ > @Prodtrans.1.ifexit_value_count@ ? @Prodtrans.ifexit_value_count@ : @Prodtrans.1.ifexit_value_count@;
		   @t check_ifexit_value_count(@Prodtrans.ifexit_value_count@, @Prodtrans.ifexit_count@, @Prodtrans.1.ifexit_value_count@, @Prodtrans.1.ifexit_count@);
		@}
		
		;

Ifexit:		  IF Bool THEN Prodtrans EXIT
		@{ @i @Prodtrans.input_table@ = clone_table(@Ifexit.input_table@);
		   /* we must be inside a loop because Ifexit may only appear inside a loop */
		   @i @Prodtrans.inloop@ = 1;
		   @i @Prodtrans.input_values@ = 0;
		   @i @Ifexit.ifexit_value_count@ = @Prodtrans.output_values@;
		   @t check_ifexit_value_count(@Prodtrans.ifexit_value_count@, @Prodtrans.ifexit_count@, @Ifexit.ifexit_value_count@, 1);
		@}
		
		;

Loop:		  START ASSIGN Trans REPEAT
		@{ @i @Trans.inloop@ = 1;
		   @i @Loop.output_values@ = @Trans.ifexit_value_count@;
		   @t check_ifexit_count(@Trans.ifexit_count@);
		   @t check_value_count(@Trans.input_values@, @Trans.output_values@);
		@}
		
		| START ASSIGN REPEAT
		@{ @t check_ifexit_count(0);
		   @i @Loop.output_values@ = @Loop.input_values@;
		@}

		;

Consumers:	  Consumer
		@{ @i @Consumers.output_table@ = table_merge(@Consumers.input_table@, @Consumer.output_table@);
		   @t check_value_count(@Consumers.input_values@, 1);
		@}
		
		| Consumer ',' Consumers
		@{ @i @Consumers.output_table@ = table_merge(@Consumers.1.output_table@, @Consumer.output_table@);
		   @i @Consumers.1.input_table@ = clone_table(@Consumers.input_table@);
		   @i @Consumers.1.input_values@ = @Consumers.input_values@ - 1;
		   @t check_value_count(@Consumers.input_values@, @Consumers.1.input_values@ + 1);
		@}

		;

Consumer:	  ID
		@{ @i @Consumer.output_table@ = table_add_symbol(new_table(), @ID.name@);
		@}
		
		| '*' Term
		@{ @i @Consumer.output_table@ = new_table();
		@}

		;

Exprs:		  Expr
		@{ @i @Exprs.output_values@ = 1;
		@}
		
		| Expr ',' Exprs
		@{ @i @Exprs.output_values@ = @Exprs.1.output_values@ + 1;
		@}

		;

Expr:		  '-' Term
		| '*' Term
		| Term Plusterm
		| Term Malterm
		| Term
		;

Plusterm:	  '+' Term
		| '+' Term Plusterm
		;

Malterm:	  '*' Term
		| '*' Term Malterm
		;

Term:		  '(' Expr ')'
		| NUM
		| ID
		@{ @t check_symbol_defined(@Term.input_table@, @ID.name@);
		@}
		
		| ID '(' Exprs ')'
		;

Bool:		  Bterm Bterms
		| NOT Bterm
		| Bterm
		;

Bterms:		  AND Bterm
		| AND Bterm Bterms
		;
		
Bterm:		  Expr '>' Expr
		| Expr '=' Expr
		| '(' Bool ')'
		;

%%

extern int yylex();
extern int line_number;

int yyerror(char *error_text) {
	(void)fprintf(stderr, "Line %i: %s\n", line_number,error_text);
	(void)fflush(stderr);
	syntax_errors++;
}

int main(int argc, char **argv) {
	yyparse();
	if(lexical_errors>0 || syntax_errors>0 || attributed_errors>0) {
		(void)fprintf(stderr, "\nProcessing input not successful\n");
		(void)fprintf(stderr, "Lexical errors: %i\n",lexical_errors);
		(void)fprintf(stderr, "Lexical warnings: %i\n",lexical_warnings);
		(void)fprintf(stderr, "Syntax errors: %i\n",syntax_errors);
		(void)fprintf(stderr, "Other errors: %i\n",attributed_errors);
		(void)fflush(stderr);
	}
	remove_all_lists();
	if(lexical_errors>0) {
		return(1);
	}
	if(syntax_errors>0) {
		return(2);
	}
	if(attributed_errors>0) {
		return(3);
	}
	return(0);
}


