package at.ac.tuwien.dslab.rmi.server;

import java.net.URI;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;

import at.ac.tuwien.dslab.rmi.common.DSLabUtils;
import at.ac.tuwien.dslab.rmi.common.SkyNetException;
import at.ac.tuwien.dslab.rmi.common.interfaces.ISkyNetServer;

public class SkyNetServerImpl implements ISkyNetServer {

	private Properties props;
	private String rmiURIString;
	private SkyNetManagerImpl manager;
	
	public SkyNetServerImpl(Properties props) throws RemoteException {
		super();
		this.props = props;
	}
	
	public void start(URI[] managerURIs) throws SkyNetException {
		// create RMI URI (//www.dslab.tuwien.ac.at:1099/DSLabSkyNet1)
		this.rmiURIString = "rmi://" + props.getProperty("RMI_HOSTNAME")+
		                    ":" + props.getProperty("RMI_PORT") + 
		                    "/" + props.getProperty("RMI_OBJECT");
		try {
			URI rmiURI = new URI(rmiURIString);
			URI dbServiceURI = new URI(props.getProperty("RMI_DBSERVICE_URL"));
			this.manager = new SkyNetManagerImpl(rmiURI, dbServiceURI, managerURIs);
			System.out.println("Binding to " + rmiURIString);
			Naming.rebind(rmiURIString, manager);
		} catch (Exception e) {
			System.err.println(e);
		}
	} // end start

	public void stop() throws SkyNetException {
		// unbind RMI server object and unexport it
		try {
			Naming.unbind(rmiURIString);
			UnicastRemoteObject.unexportObject(manager, true);
		}
		catch (Exception e) {
			System.err.println(e);
		}
	} // end stop

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		Properties props = null;
		URI[] managers = null;
		//SkyNetServerImpl server = null;

		try {
			if (args.length > 1) {
				managers = new URI[args.length-1];
			}
			for (int i=1; i < args.length; i++) {
				managers[i-1] = new URI(args[i]);
			}
			props = DSLabUtils.loadPropertiesFromFile(args[0]);
			new SkyNetServerImpl(props).start(managers);
			System.out.println("Server started.");			
		} catch(Exception e) {
			System.err.println(e);
		}

	} // end main

}
