package at.ac.tuwien.dslab.rmi.server;

import java.net.URI;
import java.rmi.Naming;

import at.ac.tuwien.dslab.rmi.common.interfaces.*;

public class ConnectThread extends Thread {

	protected static final int CONNECT_RETRIES = 5;
	protected static final int CONNECT_TIMEOUT = 3000;
	
	private URI[] buddyManagerURIs;
	private ISkyNetListener listener;
	
	public ConnectThread(ISkyNetListener listener, URI[] buddyManagerURIs) {
		super("ConnectThread");
		this.listener = listener;
		this.buddyManagerURIs = buddyManagerURIs;
	}
	
	public void run() {
		if (buddyManagerURIs == null) {
			return;
		}
		
		for (int i=0; i < ConnectThread.CONNECT_RETRIES+1; i++) {
			try {
				Thread.sleep(ConnectThread.CONNECT_TIMEOUT);
			} catch(Exception e) {
				System.err.println(e);
			}
			for (int k=0; k < buddyManagerURIs.length; k++) {
				try {
					if (buddyManagerURIs[k] != null) {
						System.out.println("Looking up " + buddyManagerURIs[k]);
						ISkyNetManager manager = (ISkyNetManager) Naming.lookup(buddyManagerURIs[k].toString());
						manager.addSkyNetListener(listener);
						buddyManagerURIs[k] = null;
					}
				} catch (Exception e) {
					System.err.println(e);
				}
			}
		}
	} // end run

}
